﻿Public Class frmPrincipal
    Private cifraMae As New modCifragem.clsCifras
    Private _cancela As Boolean
    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Dim nome As String = String.Empty, I As Integer = 0
        nome = cifraMae.NomeDaCifra(I)
        Do While (nome <> String.Empty)
            Me.cmbTiposCifra.Items.Add(nome)
            I += 1
            nome = cifraMae.NomeDaCifra(I)
        Loop
        Me.cmbTiposCifra.SelectedIndex = 0
    End Sub

    Private Sub btnCifrar_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCifrar.Click
        Try
            Dim cifra As Object = EscolheCifra()
            If Me._cancela Then Exit Sub
            Me.txtCifrado.Text = cifra.Cifra(Me.txtPlano.Text)
            If Me.txtChave.Visible Then Me.txtChave.Text = cifra.Chave Else Me.nupChave.Value = cifra.Chave
            If TryCast(cifra, modCifragem.clsFraseChave) IsNot Nothing Then Me.txtLetraChave.Text = cifra.LetraChave
        Catch ex As Exception
            MessageBox.Show(ex.Message, "Erro ao cifrar!", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try

    End Sub

    Private Sub btnDecifrar_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDecifrar.Click
        Try
            Dim cifra As Object = EscolheCifra()
            If Me._cancela Then Exit Sub
            Me.txtPlano.Text = cifra.Decifra(Me.txtCifrado.Text)
            If Me.txtChave.Visible Then Me.txtChave.Text = cifra.Chave Else Me.nupChave.Value = cifra.Chave
            If TryCast(cifra, modCifragem.clsFraseChave) IsNot Nothing Then Me.txtLetraChave.Text = cifra.LetraChave
        Catch ex As Exception
            MessageBox.Show(ex.Message, "Erro ao decifrar!", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub
    Public Function EscolheCifra() As Object
        Dim cifra As New Object
        Try
            Select Case Me.cmbTiposCifra.SelectedIndex
                Case modCifragem.clsCifras.enuCifras.Caesar : cifra = New modCifragem.clsCaesar(CInt(Me.nupChave.Value), Me.chkEspacos.Checked)
                Case modCifragem.clsCifras.enuCifras.Blocos : cifra = New modCifragem.clsBlocos(Me.nupChave.Value, Me.chkEspacos.Checked)
                Case modCifragem.clsCifras.enuCifras.Permutas : cifra = New modCifragem.clsPermuta(Me.txtChave.Text, Me.chkEspacos.Checked)
                Case modCifragem.clsCifras.enuCifras.FraseChave : cifra = New modCifragem.clsFraseChave(Me.txtChave.Text, Me.txtLetraChave.Text, Me.chkEspacos.Checked)
                Case modCifragem.clsCifras.enuCifras.Viginere : cifra = New modCifragem.clsVigenere(Me.txtChave.Text, Me.chkEspacos.Checked)
                Case modCifragem.clsCifras.enuCifras.Multiplicativa : cifra = New modCifragem.clsMultiplicativa(Me.nupChave.Value, Me.chkEspacos.Checked)
                Case modCifragem.clsCifras.enuCifras.Afim : cifra = New modCifragem.clsAfim(Me.nupChave.Value, Me.nupChaveM.Value, Me.chkEspacos.Checked)
                Case Else : cifra = New modCifragem.clsCaesar(CInt(Me.nupChave.Text), Me.chkEspacos.Checked)
            End Select
            Me._cancela = False
        Catch ex As Exception
            Me._cancela = True
            MessageBox.Show(ex.Message, "Erro nas escolhas!", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
        Return cifra
    End Function
    Private Sub Form1_Resize(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Resize
        Dim altura As Integer = (Me.Height - 176) / 2
        Dim posi As Integer = Me.btnDecifrar.Location.Y + 55
        Me.txtPlano.Size = New Size(Me.txtPlano.Width, altura)
        Me.txtCifrado.Size = New Size(Me.txtCifrado.Width, altura)
        Me.txtCifrado.Location = New Point(Me.txtCifrado.Location.X, posi)
        Me.lblCifrado.Location = New Point(Me.lblCifrado.Location.X, posi)
    End Sub

    Private Sub cmbTiposCifra_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbTiposCifra.SelectedIndexChanged
        Dim val As Boolean = (cifraMae.TipoDeChave(Me.cmbTiposCifra.SelectedIndex) = modCifragem.clsCifras.enuTipos.Inteiro)
        Me.txtChave.Visible = Not (val)
        Me.nupChave.Visible = val
        Me.txtLetraChave.Visible = (Me.cmbTiposCifra.SelectedIndex = modCifragem.clsCifras.enuCifras.FraseChave)
        Me.lblLetraChave.Visible = (Me.cmbTiposCifra.SelectedIndex = modCifragem.clsCifras.enuCifras.FraseChave)
        Dim aux As Boolean = (Me.cmbTiposCifra.SelectedIndex = modCifragem.clsCifras.enuCifras.Afim)
        Me.lblM.Visible = aux
        Me.lblS.Visible = aux
        Me.nupChaveM.Visible = aux
    End Sub

    Private Sub txtPlano_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txtPlano.TextChanged
        Me.lblContaL.Text = String.Format("Nº de caracteres: {0}", Me.txtPlano.Text.Length)
    End Sub

    Private Sub SobreToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SobreToolStripMenuItem.Click
        frmSobre.ShowDialog()
    End Sub
End Class
