/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImageDisplay
extends JPanel {
    private Image image;
    private Point zero;
    private Dimension dim;
    private BufferedImage offImage;
    private Graphics2D offGrfx;
    private AffineTransform at;
    private boolean shrink;
    private double zoom = 1.0;
    private int k = 0;

    public ImageDisplay() {
        this.initComponents();
        this.dim = this.getSize();
        this.zero = new Point();
        this.at = new AffineTransform();
    }

    private void initComponents() {
        this.setCursor(Cursor.getPredefinedCursor(13));
        this.setBackground(new Color(255, 255, 255));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                ImageDisplay.this.setZero(evt.getX(), evt.getY());
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                ImageDisplay.this.translate(evt.getX(), evt.getY());
            }
        });
    }

    public void paint(Graphics g) {
        int flag;
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!this.dim.equals(this.getSize()) || this.offImage == null) {
            this.dim = this.getSize();
            this.offImage = (BufferedImage)this.createImage(this.dim.width, this.dim.height);
            this.offGrfx = this.offImage.createGraphics();
        }
        if (((flag = this.checkImage(this.image, this)) & 0x20) != 0) {
            if (this.shrink) {
                this.drawShrinkedPicture();
            } else if (this.zoom != 1.0) {
                this.drawZoomPicture();
            } else {
                this.drawPicture();
            }
        } else if ((flag & 0x80) != 0) {
            this.drawAbort();
        } else if ((flag & 0x40) != 0) {
            this.drawError();
        } else {
            this.drawLoading();
        }
        g2D.drawImage((Image)this.offImage, 0, 0, this);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public boolean imageUpdate(Image image, int flags, int x, int y, int width, int height) {
        if ((flags & 2) == 0 && (flags & 1) == 0 && (flags & 0x10) == 0 && (flags & 8) == 0) {
            if ((flags & 0x20) != 0) {
                System.out.println("Image complete " + this.k);
                if (image.equals(this.image)) {
                    this.repaint();
                }
                ++this.k;
                return false;
            }
            if ((flags & 0x80) != 0) {
                System.out.println("Image load aborted...");
                this.repaint();
                return false;
            }
            if ((flags & 0x40) != 0) {
                System.out.println("Image error...");
                this.repaint();
                return false;
            }
        }
        return true;
    }

    public void setImage(Image img) {
        this.image = img;
        this.at.setToTranslation(0.0, 0.0);
        this.repaint();
    }

    private void drawError() {
        String str = "Image error.";
        this.drawText(str);
    }

    private void drawAbort() {
        String str = "Image load aborted.";
        this.drawText(str);
    }

    private void drawLoading() {
        String str = "Loading...";
        this.drawText(str);
    }

    private void drawText(String str) {
        Font font = new Font("Helvetica", 0, 14);
        FontMetrics fm = this.offGrfx.getFontMetrics(font);
        int x = (this.dim.width - fm.stringWidth(str)) / 2;
        int y = (this.dim.height - fm.getHeight()) / 2 + fm.getAscent();
        this.offGrfx.setColor(Color.WHITE);
        this.offGrfx.fillRect(0, 0, this.dim.width, this.dim.height);
        this.offGrfx.setFont(font);
        this.offGrfx.setColor(Color.BLACK);
        this.offGrfx.drawString(str, x, y);
    }

    private void drawPicture() {
        double width = this.image.getWidth(this);
        double height = this.image.getHeight(this);
        double x = this.at.getTranslateX();
        double y = this.at.getTranslateY();
        if (x > 0.0) {
            x = 0.0;
        } else if (x + width < (double)this.dim.width) {
            x = -(width - (double)this.dim.width);
        }
        if (y > 0.0) {
            y = 0.0;
        } else if (y + height < (double)this.dim.height) {
            y = -(height - (double)this.dim.height);
        }
        if (width < (double)this.dim.width && height < (double)this.dim.height) {
            x = ((double)this.dim.width - width) / 2.0;
            y = ((double)this.dim.height - height) / 2.0;
        } else if (width > (double)this.dim.width && height < (double)this.dim.height) {
            y = ((double)this.dim.height - height) / 2.0;
        } else if (width < (double)this.dim.width && height > (double)this.dim.height) {
            x = ((double)this.dim.width - width) / 2.0;
        }
        this.at.setToTranslation(x, y);
        this.offGrfx.setColor(Color.WHITE);
        this.offGrfx.fillRect(0, 0, this.dim.width, this.dim.height);
        this.offGrfx.drawImage(this.image, this.at, this);
    }

    private void drawShrinkedPicture() {
        double width = this.image.getWidth(this);
        double height = this.image.getHeight(this);
        double scale = 1.0;
        if (width > (double)this.dim.width && height > (double)this.dim.height) {
            scale = (double)this.dim.width / width;
            double new_height = height * scale;
            if (new_height > (double)this.dim.height) {
                scale *= (double)this.dim.height / new_height;
            }
        } else if (width > (double)this.dim.width && height < (double)this.dim.height) {
            scale = (double)this.dim.width / width;
        } else if (width < (double)this.dim.width && height > (double)this.dim.height) {
            scale = (double)this.dim.height / height;
        }
        double tx = ((double)this.dim.width - (width *= scale)) / 2.0;
        double ty = ((double)this.dim.height - (height *= scale)) / 2.0;
        this.at.setToTranslation(tx, ty);
        this.at.scale(scale, scale);
        this.offGrfx.setColor(Color.WHITE);
        this.offGrfx.fillRect(0, 0, this.dim.width, this.dim.height);
        this.offGrfx.drawImage(this.image, this.at, this);
    }

    private void drawZoomPicture() {
        double width = (double)this.image.getWidth(this) * this.zoom;
        double height = (double)this.image.getHeight(this) * this.zoom;
        double x = this.at.getTranslateX();
        double y = this.at.getTranslateY();
        if (x > 0.0) {
            x = 0.0;
        } else if (x + width < (double)this.dim.width) {
            x = -(width - (double)this.dim.width);
        }
        if (y > 0.0) {
            y = 0.0;
        } else if (y + height < (double)this.dim.height) {
            y = -(height - (double)this.dim.height);
        }
        if (width < (double)this.dim.width && height < (double)this.dim.height) {
            x = ((double)this.dim.width - width) / 2.0;
            y = ((double)this.dim.height - height) / 2.0;
        } else if (width > (double)this.dim.width && height < (double)this.dim.height) {
            y = ((double)this.dim.height - height) / 2.0;
        } else if (width < (double)this.dim.width && height > (double)this.dim.height) {
            x = ((double)this.dim.width - width) / 2.0;
        }
        this.at.setToTranslation(x, y);
        this.at.scale(this.zoom, this.zoom);
        this.offGrfx.setColor(Color.WHITE);
        this.offGrfx.fillRect(0, 0, this.dim.width, this.dim.height);
        this.offGrfx.drawImage(this.image, this.at, this);
    }

    public void setZero(int x, int y) {
        this.zero.move(x, y);
    }

    public void setShrink(boolean b) {
        this.shrink = b;
        this.repaint();
    }

    public void translate(int xx, int yy) {
        int dx = xx - this.zero.x;
        int dy = yy - this.zero.y;
        int x = (int)this.at.getTranslateX() + dx;
        int y = (int)this.at.getTranslateY() + dy;
        this.at.setToTranslation(x, y);
        this.zero.move(xx, yy);
        this.repaint();
    }

    public void setZoom(double z) {
        this.zoom = z;
        this.repaint();
    }
}

