/*
 * JavaSee.java
 *
 * Created on 25 de Outubro de 2004, 22:41
 */

import java.awt.Image;
import java.util.Vector;
import java.net.URL;
import java.util.StringTokenizer;

/**
 *
 * @author  Bruno
 */
public class JavaSee extends javax.swing.JApplet implements Runnable {
    
    // Directoria onde se encontram as imagens
    private final static String IMAGES_DIR = "images";
    
    
    /** Initializes the applet JavaSee */
    public void init() {
        initComponents();
        initMyComponents();
        
        String filesNames = getParameter("imagefiles");
        if(filesNames != null) {
            loadImages(filesNames);
        }
        else {
            loadImages();
        }
        loadInitialImage(0);
    }
    
    /** Inicializa o ImageDisplay para mostrar a imagem */
    private void initMyComponents() {
        display = new ImageDisplay();
        jPanel2.add(display, java.awt.BorderLayout.CENTER); 
    }
    
    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        jToolBar1 = new javax.swing.JToolBar();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();
        jButton4 = new javax.swing.JButton();
        jButton5 = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jToolBar2 = new javax.swing.JToolBar();
        jToggleButton1 = new javax.swing.JToggleButton();
        jToggleButton2 = new javax.swing.JToggleButton();
        jToggleButton3 = new javax.swing.JToggleButton();
        jPanel2 = new javax.swing.JPanel();

        jPanel1.setBackground(new java.awt.Color(255, 153, 102));

        jToolBar1.setFloatable(false);
        jToolBar1.setRollover(true);

        jButton1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/previous.gif"))); // NOI18N
        jButton1.setBorderPainted(false);
        jButton1.setContentAreaFilled(false);
        jButton1.setFocusPainted(false);
        jButton1.setPreferredSize(new java.awt.Dimension(40, 40));
        jButton1.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/previous_pressed.gif"))); // NOI18N
        jButton1.setRolloverIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/previous_over.gif"))); // NOI18N
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        jButton1.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                jButton1KeyPressed(evt);
            }
        });
        jToolBar1.add(jButton1);

        jButton2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/play.gif"))); // NOI18N
        jButton2.setBorderPainted(false);
        jButton2.setContentAreaFilled(false);
        jButton2.setFocusPainted(false);
        jButton2.setPreferredSize(new java.awt.Dimension(40, 40));
        jButton2.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/play_pressed.gif"))); // NOI18N
        jButton2.setRolloverIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/play_over.gif"))); // NOI18N
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });
        jButton2.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                jButton2KeyPressed(evt);
            }
        });
        jToolBar1.add(jButton2);

        jButton3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/pause.gif"))); // NOI18N
        jButton3.setBorderPainted(false);
        jButton3.setContentAreaFilled(false);
        jButton3.setFocusPainted(false);
        jButton3.setPreferredSize(new java.awt.Dimension(40, 40));
        jButton3.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/pause_pressed.gif"))); // NOI18N
        jButton3.setRolloverIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/pause_over.gif"))); // NOI18N
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });
        jButton3.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                jButton3KeyPressed(evt);
            }
        });
        jToolBar1.add(jButton3);

        jButton4.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/stop.gif"))); // NOI18N
        jButton4.setBorderPainted(false);
        jButton4.setContentAreaFilled(false);
        jButton4.setFocusPainted(false);
        jButton4.setPreferredSize(new java.awt.Dimension(40, 40));
        jButton4.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/stop_pressed.gif"))); // NOI18N
        jButton4.setRolloverIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/stop_over.gif"))); // NOI18N
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton4ActionPerformed(evt);
            }
        });
        jButton4.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                jButton4KeyPressed(evt);
            }
        });
        jToolBar1.add(jButton4);

        jButton5.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/foward.gif"))); // NOI18N
        jButton5.setBorderPainted(false);
        jButton5.setContentAreaFilled(false);
        jButton5.setFocusPainted(false);
        jButton5.setPreferredSize(new java.awt.Dimension(40, 40));
        jButton5.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/foward_pressed.gif"))); // NOI18N
        jButton5.setRolloverIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/foward_over.gif"))); // NOI18N
        jButton5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton5ActionPerformed(evt);
            }
        });
        jButton5.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                jButton5KeyPressed(evt);
            }
        });
        jToolBar1.add(jButton5);

        jPanel1.add(jToolBar1);

        getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);

        jPanel3.setBackground(new java.awt.Color(255, 204, 153));

        jToolBar2.setFloatable(false);
        jToolBar2.setOrientation(1);
        jToolBar2.setRollover(true);

        jToggleButton1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/best_fit.gif"))); // NOI18N
        jToggleButton1.setBorderPainted(false);
        jToggleButton1.setContentAreaFilled(false);
        jToggleButton1.setMaximumSize(new java.awt.Dimension(52, 51));
        jToggleButton1.setMinimumSize(new java.awt.Dimension(52, 51));
        jToggleButton1.setPreferredSize(new java.awt.Dimension(40, 40));
        jToggleButton1.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/best_fit_pressed.gif"))); // NOI18N
        jToggleButton1.setRolloverIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/best_fit_over.gif"))); // NOI18N
        jToggleButton1.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/best_fit_pressed.gif"))); // NOI18N
        jToggleButton1.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jToggleButton1ItemStateChanged(evt);
            }
        });
        jToolBar2.add(jToggleButton1);

        buttonGroup1.add(jToggleButton2);
        jToggleButton2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/zoom_more.gif"))); // NOI18N
        jToggleButton2.setBorderPainted(false);
        jToggleButton2.setContentAreaFilled(false);
        jToggleButton2.setMaximumSize(new java.awt.Dimension(52, 51));
        jToggleButton2.setMinimumSize(new java.awt.Dimension(52, 51));
        jToggleButton2.setPreferredSize(new java.awt.Dimension(40, 40));
        jToggleButton2.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/zoom_more_pressed.gif"))); // NOI18N
        jToggleButton2.setRolloverIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/zoom_more_over.gif"))); // NOI18N
        jToggleButton2.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/zoom_more_pressed.gif"))); // NOI18N
        jToggleButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButton2ActionPerformed(evt);
            }
        });
        jToolBar2.add(jToggleButton2);

        buttonGroup1.add(jToggleButton3);
        jToggleButton3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/zoom_less.gif"))); // NOI18N
        jToggleButton3.setSelected(true);
        jToggleButton3.setBorderPainted(false);
        jToggleButton3.setContentAreaFilled(false);
        jToggleButton3.setMaximumSize(new java.awt.Dimension(52, 51));
        jToggleButton3.setMinimumSize(new java.awt.Dimension(52, 51));
        jToggleButton3.setPreferredSize(new java.awt.Dimension(40, 40));
        jToggleButton3.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/zoom_less_pressed.gif"))); // NOI18N
        jToggleButton3.setRolloverIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/zoom_less_over.gif"))); // NOI18N
        jToggleButton3.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/Themes/Default/zoom_less_pressed.gif"))); // NOI18N
        jToggleButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButton3ActionPerformed(evt);
            }
        });
        jToolBar2.add(jToggleButton3);

        jPanel3.add(jToolBar2);

        getContentPane().add(jPanel3, java.awt.BorderLayout.EAST);

        jPanel2.setBackground(new java.awt.Color(255, 255, 255));
        jPanel2.setLayout(new java.awt.BorderLayout());
        getContentPane().add(jPanel2, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    private void jToggleButton1ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButton1ItemStateChanged
        if(evt.getStateChange() == evt.SELECTED) {
            display.setShrink(true);
            jToggleButton2.setEnabled(false);
            jToggleButton3.setEnabled(false);
        }
        else {
            display.setShrink(false);
            jToggleButton2.setEnabled(true);
            jToggleButton3.setEnabled(true);
        }
    }//GEN-LAST:event_jToggleButton1ItemStateChanged

    private void jToggleButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButton3ActionPerformed
        if(jToggleButton1.isSelected()) 
            return;
        display.setZoom(1);
    }//GEN-LAST:event_jToggleButton3ActionPerformed

    private void jToggleButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButton2ActionPerformed
        if(jToggleButton1.isSelected()) 
            return;
        display.setZoom(2);
    }//GEN-LAST:event_jToggleButton2ActionPerformed
  
    private void jButton5KeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jButton5KeyPressed
        keyPressed(evt);
    }//GEN-LAST:event_jButton5KeyPressed

    private void jButton4KeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jButton4KeyPressed
        keyPressed(evt);
    }//GEN-LAST:event_jButton4KeyPressed

    private void jButton3KeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jButton3KeyPressed
        keyPressed(evt);
    }//GEN-LAST:event_jButton3KeyPressed

    private void jButton2KeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jButton2KeyPressed
        keyPressed(evt);
    }//GEN-LAST:event_jButton2KeyPressed

    private void jButton1KeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jButton1KeyPressed
        keyPressed(evt);
    }//GEN-LAST:event_jButton1KeyPressed

    private void jButton5ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton5ActionPerformed
        // Para o slideshow
        if(play)
            play = false;
        
        nextImage();
    }//GEN-LAST:event_jButton5ActionPerformed

    private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton4ActionPerformed
        istop();
    }//GEN-LAST:event_jButton4ActionPerformed

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        pause();
    }//GEN-LAST:event_jButton3ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        play();
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        // Para o slideshow
        if(play)
            play = false;
        
        previousImage();
    }//GEN-LAST:event_jButton1ActionPerformed
      
    
    /** Carrega o vector 'images' com o nome dos ficheiros */
    private void loadImages() {
        URL url;
        
        try {
            url = new URL(getCodeBase(), IMAGES_DIR);
            images = WebFile.list(url);
        }
        catch(java.net.MalformedURLException e) {
            e.printStackTrace();
        }
    }
    
    /** Carrega o vector 'images' com o nome dos ficheiros definidos no html */
    private void loadImages(String filesNames) {
        images = new Vector();
        try {
            StringTokenizer t = new StringTokenizer(filesNames);
            for(int i = 0 ; t.hasMoreTokens() ; i++) { 
                images.add(t.nextToken());
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }
    
    /** Carrega a imagem inicial no ecran */
    private void loadInitialImage(int p) {
        // Posiciona o index na imagem pretendida
        index = p;
           
        // Inicia o download da imagem para mostrar
        actual = getImage(getCodeBase(), 
            IMAGES_DIR + "/" + (String) images.elementAt(index));  
        prepareImage(actual, display);
        
        // Carrega a imagem seguinte
        if(index+1 < images.size()) {   
            next = getImage(getCodeBase(), 
                IMAGES_DIR + "/" + (String) images.elementAt(index+1));
            prepareImage(next, display);
        }
        
        // Carrega a imagem anterior
        if(index-1 > 0) {   
            previous = getImage(getCodeBase(), 
                IMAGES_DIR + "/" + (String) images.elementAt(index-1));
            prepareImage(previous, display);
        }
        
        // Mostra a imagem
        display.setImage(actual); 
    }
    
    /** Muda para a imagem seguinte */
    public void nextImage() {
        if(index == images.size()-1)
            return;
        
        previous = actual;
        actual = next;
      
        index++;
        if(index+1 < images.size()) {   
            next = getImage(getCodeBase(), 
                IMAGES_DIR + "/" + (String) images.elementAt(index+1)); 
        }
        else {
            next = getImage(getCodeBase(), 
                IMAGES_DIR + "/" + (String) images.elementAt(0));     
        }
        prepareImage(next, display);        
        display.setImage(actual);    
    }
     
    /** Muda para a imagem anterior */
    public void previousImage() {
        if(index == 0)
            return;
        
        next = actual;
        actual = previous;
        
        index--;
        if(index-1 > -1) {   
            previous = getImage(getCodeBase(), 
                IMAGES_DIR + "/" + (String) images.elementAt(index-1));
            prepareImage(previous, display);
        }
        display.setImage(actual);    
    }
    
    /** Inicia o slideshow */
    public void play() {
        if(!play) {
            play = true;
            runner = new Thread(this);
            runner.start();
        }
    }
    
    /** Faz pause no slideshow */
    public void pause() {
        play = false;
    }
    
    /** Igual ao pause */ 
    public void istop() {
        play = false;
    }
    
    /** */
    private void keyPressed(java.awt.event.KeyEvent evt) {
        switch(evt.getKeyCode()) {
            case java.awt.event.KeyEvent.VK_PAGE_UP:
                previousImage();
                break;
            case java.awt.event.KeyEvent.VK_PAGE_DOWN:
                nextImage();
                break;
            case java.awt.event.KeyEvent.VK_ADD: 
                break;
        }
    }  
    
    /** Para a tread se tiver a correr e sai da applet */
    public void stop() {
        play = false;
        runner = null;
    }
    
    /** Thread para fazer o slideshow */
    public void run() {
        try { Thread.sleep(2000); }
        catch(java.lang.InterruptedException e) {}
 
        while(play) {
            // Serve para ter o slideshow continuo
            if(index == images.size()-1)
                index = 0;
            
            // mostra a imagem seguinte
            nextImage();
            
            try { Thread.sleep(2000); }
            catch(java.lang.InterruptedException e) {}
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JButton jButton5;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JToggleButton jToggleButton1;
    private javax.swing.JToggleButton jToggleButton2;
    private javax.swing.JToggleButton jToggleButton3;
    private javax.swing.JToolBar jToolBar1;
    private javax.swing.JToolBar jToolBar2;
    // End of variables declaration//GEN-END:variables
    private ImageDisplay display;
    private Vector images;
    private Image previous;
    private Image actual;
    private Image next;
    private Thread runner;
    private int index;       
    private boolean play = false;
}

