Imports System.Net

Public Class frmMain

    ''' <summary>
    ''' Pesquisa pelas letras da msica, caso a opo esteja activa
    ''' </summary>
    Private Sub notifIcon_BalloonTipClicked(ByVal sender As Object, ByVal e As System.EventArgs) Handles notifIcon.BalloonTipClicked
        If My.Settings.pesquisaGoogle Then
            ' pesquisa Google
            System.Diagnostics.Process.Start("http://www.google.pt/search?hl=pt-PT&q=" & notifIcon.BalloonTipText & " lyrics")
        End If
    End Sub

    ''' <summary>
    ''' Obtem a msica a tocar actualmente na RFM, atravs do website oficial
    ''' </summary>
    Private Sub notifIcon_MouseClick(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles notifIcon.MouseClick
        If e.Button = Windows.Forms.MouseButtons.Left And notifIcon.Tag <> "lock" Then
            ' buscar informaes pretendidas
            ' bloquear novos pedidos
            notifIcon.Tag = "lock"
            notifIcon.Icon = My.Resources.inactivo
            notifIcon.Text = "Por favor aguarde..."

            ' Criar o cliente que vai buscar a pgina
            Dim cliente As WebClient = New WebClient

            ' camuflar o cliente como sendo o Firefox, para evitar possveis problemas
            cliente.Headers.Add(HttpRequestHeader.UserAgent, "Mozilla/5.0 (Windows; U; Windows NT 5.1; pt-PT; rv:1.9) Gecko/2008052906 Firefox/3.0")
            cliente.Headers.Add(HttpRequestHeader.Accept, "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8")
            cliente.Headers.Add(HttpRequestHeader.AcceptCharset, "ISO-8859-1,utf-8;q=0.7,*;q=0.7")
            cliente.Headers.Add(HttpRequestHeader.Referer, "http://www.rfm.pt/")

            ' download da pgina
            Dim textoRFM As String = cliente.DownloadString("http://www.rfm.pt/p_quemusicaera.aspx")

            ' procurar
            Dim textoInicial As String = "<span class=""txtmarquee"">A TOCAR AGORA :&nbsp;&nbsp;&nbsp;&nbsp;"
            Dim textoFinal As String = "</span></MARQUEE></div>"
            Dim textoFinal2 As String = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; A SEGUIR:" ' alternativa
            Dim comecaString As Integer = InStr(textoRFM, textoInicial) + textoInicial.Length - 1
            Dim comprimento As Integer = InStr(textoRFM, textoFinal) - comecaString - 1
            Dim comprimento2 As Integer = InStr(textoRFM, textoFinal2) - comecaString - 1 ' com a alternativa
            Dim procura As String

            ' ver qual dos dois mtodos era usado na pgina, e guardar a informao correcta
            If comprimento2 < 0 Then
                procura = textoRFM.Substring(comecaString, comprimento)
            Else
                procura = textoRFM.Substring(comecaString, comprimento2)
            End If

            ' desbloquear pedidos
            notifIcon.Tag = ""
            notifIcon.Icon = My.Resources.activo
            notifIcon.Text = "Clique para saber a msica que est a passar agora"

            ' mostrar as informaes
            notifIcon.BalloonTipText = allWordsCapitalize(procura)
            notifIcon.ShowBalloonTip(5000)
        End If
    End Sub

    ''' <summary>
    ''' Fecha o programa
    ''' </summary>
    Private Sub SairToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SairToolStripMenuItem.Click
        Me.Close()
    End Sub

    ''' <summary>
    ''' Carrega as opes do programa e efectua algumas rotinas adicionais
    ''' </summary>
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' carregar opes
        PesquisaGoogleToolStripMenuItem.Checked = My.Settings.pesquisaGoogle

        ' esconder formulrio
        Me.Visible = False
        Me.ShowInTaskbar = False
    End Sub

    ''' <summary>
    ''' Mostra a janela de crditos
    ''' </summary>
    Private Sub AcercaDesteProgramaToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AcercaDesteProgramaToolStripMenuItem.Click
        frmAbout.Show()
    End Sub

    ''' <summary>
    ''' Activa/desactiva a preferncia da pesquisa de letras de msicas pelo Google
    ''' </summary>
    Private Sub PesquisaGoogleToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PesquisaGoogleToolStripMenuItem.Click
        My.Settings.pesquisaGoogle = PesquisaGoogleToolStripMenuItem.Checked
    End Sub

    ''' <summary>
    ''' Capitaliza todas as palavras de uma dada frase
    ''' </summary>
    ''' <param name="frase">A frase com palavras a capitalizar</param>
    ''' <returns>Frase com palavras capitalizadas (String)</returns>
    Private Function allWordsCapitalize(ByVal frase As String) As String
        Dim todasPalavras() As String = Split(frase)
        Dim novaFrase As String = ""

        For Each palavra As String In todasPalavras
            If palavra.Length > 0 Then
                novaFrase += palavra(0)

                ' resto da frase (se houver) para minusculas
                If palavra.Length > 1 Then
                    novaFrase += palavra.Substring(1).ToLower()
                End If

                novaFrase += " "
            End If
        Next

        Return novaFrase
    End Function

    ''' <summary>
    ''' Abre o website da RFM com a programao actual
    ''' </summary>
    Private Sub SiteRFMToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SiteRFMToolStripMenuItem.Click
        System.Diagnostics.Process.Start("http://www.rfm.pt/p_quemusicaera.aspx")
    End Sub
End Class