﻿Public Class GestorLigacoes

#Region "Assinatura"
    'DataGate
    'Por Sérgio Ribeiro
    'ribeirinho55@hotmail.com
#End Region

#Region "Inicialização e Handlers de eventos"

    Sub New()
        AddHandler ER.ErroGestor, AddressOf DisparaErroGestor
        AddHandler ER.ErroDB, AddressOf DisparaErroDB
        L.RegistaLog("Gestor de ligações inicializado!", "Gestor")
    End Sub

    Private Sub DisparaErroGestor(ByVal Mensagem As String)
        RaiseEvent ErroGestor(Mensagem)
    End Sub

    Private Sub DisparaErroDB(ByVal Mensagem As String, ByVal nomeligacao As String)
        RaiseEvent ErroDB(Mensagem, nomeligacao)
    End Sub
#End Region

#Region "Declarações"
    Private Ligacoes As New Dictionary(Of String, Object)

    Public Event ErroGestor(ByVal Mensagem As String)
    Public Event ErroDB(ByVal Mensagem As String, ByVal NomeLigacao As String)

    Public Enum LigTipo
        MSSQL
        MSSQLC
        MSACCESS
    End Enum

    Public Enum TipoQuery
        Texto
        StoredProcedure
    End Enum
#End Region

#Region "Propriedades"
    ''' <summary>
    ''' Determina se deverá ser mantido um log das acções
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property ManterLog() As Boolean
        Get
            Return Prefs.EscreverLog
        End Get
        Set(ByVal value As Boolean)
            Prefs.EscreverLog = value
        End Set
    End Property

    ''' <summary>
    ''' Determina se os erros apanhados são discriminados para o log
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property ErrosParaLog() As Boolean
        Get
            Return Prefs.EscreverErrosNoLog
        End Get
        Set(ByVal value As Boolean)
            Prefs.EscreverErrosNoLog = value
            L.RegistaLog("Alterada preferência para registar erros no log. Novo valor: " & value.ToString, "Gestor")
        End Set
    End Property

    ''' <summary>
    ''' Determina e define um erro personalizado para utilizar nas excepções e eventos
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks>%%msg%% é substituído por a mensagem e %%ligacao%% é substituído por o nome da ligação</remarks>
    Public Property ErroPersonalizado() As String
        Get
            Return Prefs.ErroPers
        End Get
        Set(ByVal value As String)
            Prefs.ErroPers = value
            L.RegistaLog("Alterada preferência para usar um erro personalizado. Novo valor: " & value.ToString, "Gestor")
        End Set
    End Property

    ''' <summary>
    ''' Determina se devem ser lançadas excepções para os erros disparados por o gestor
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property LancarExcepcoesDoGestor() As Boolean
        Get
            Return Prefs.LancarEx
        End Get
        Set(ByVal value As Boolean)
            Prefs.LancarEx = value
            L.RegistaLog("Alterada preferência para lançar excepções provenientes do gestor. Novo valor: " & value.ToString, "Gestor")
        End Set
    End Property

    ''' <summary>
    ''' Determina se devem ser lançadas excepções para os erros disparados por os motores de BD
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property LancarExcepcoesAosErrosDaDB() As Boolean
        Get
            Return Prefs.LancarExDB
        End Get
        Set(ByVal value As Boolean)
            Prefs.LancarExDB = value
            L.RegistaLog("Alterada preferência para lançar excepções provenientes dos motores de BD. Novo valor: " & value.ToString, "Gestor")
        End Set
    End Property
#End Region

#Region "Log"
    ''' <summary>
    ''' Devolve as últimas n entradas do log
    ''' </summary>
    ''' <param name="NumeroDeEntradas"></param>
    ''' <returns>List(Of String) onde cada linha é uma entrada</returns>
    ''' <remarks>Se não fornecer o número de entradas, serão todas devolvidas</remarks>
    Public Function DevolverUltimasEntradasDoLog(Optional ByVal NumeroDeEntradas As Integer = 0) As List(Of String)
        Return L.DevolverUltimasEntradas(NumeroDeEntradas)
        L.RegistaLog("Últimas entradas do log devolvidas", "Gestor")
    End Function

    ''' <summary>
    ''' Limpa todas as entradas do log
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub LimparLog()
        L.LimparLog()
        L.RegistaLog("Entradas do log limpas [" & Now.ToShortDateString & " - " & Now.ToShortTimeString & "]", "Gestor")
    End Sub
#End Region

#Region "Métodos expostos"

    ''' <summary>
    ''' Devolve o tipo da ligação associado ao nome fornecido
    ''' </summary>
    ''' <param name="NomeLigacao">Nome da ligação a verificar</param>
    ''' <returns>String. Tipo da ligação</returns>
    ''' <remarks></remarks>
    Public Function TipoDaLigacao(ByVal NomeLigacao As String) As String
        If LigacaoExiste(LCase(NomeLigacao)) = False Then
            ER.ReportarErro(ErrorReporting.NV.Gestor, "Ligação inexistente")
            Return String.Empty
        End If

        Dim P() As String = Split(Ligacoes(LCase(NomeLigacao)).ToString, ".")
        Dim Tipo As String = LCase(P(UBound(P)))

        Select Case Tipo

            Case "accessmotor"
                Dim TempT As ACCESSMotor = CType(Ligacoes(LCase(NomeLigacao)), ACCESSMotor)
                Return TempT.Tipo

            Case "sqlmotor"
                Dim TempT As SQLMotor = CType(Ligacoes(LCase(NomeLigacao)), SQLMotor)
                Return TempT.Tipo

            Case "sqlcmotor"
                Dim TempT As SQLCMotor = CType(Ligacoes(LCase(NomeLigacao)), SQLCMotor)
                Return TempT.Tipo

        End Select

        Return "Tipo desconhecido"
    End Function

    ''' <summary>
    ''' Adiciona uma nova ligação no gestor de ligações
    ''' </summary>
    ''' <param name="TipoLigacao">Tipo da ligação a abrir</param>
    ''' <param name="NomeLigacao">Nome de identificação da ligação</param>
    ''' <returns>Boolean. True se sucesso, False se surgir um erro</returns>
    ''' <remarks></remarks>
    Public Function AdicionarLigacao(ByVal TipoLigacao As LigTipo, ByVal NomeLigacao As String) As Boolean

        If LigacaoExiste(LCase(NomeLigacao)) = True Then
            ER.ReportarErro(ErrorReporting.NV.Gestor, "Ligação já existe")
            Return False
        End If

        Select Case TipoLigacao

            Case LigTipo.MSACCESS

                Dim NewLig As New ACCESSMotor(NomeLigacao)
                Ligacoes.Add(LCase(NomeLigacao), NewLig)
                L.RegistaLog("Nova ligação ACCESS adicionada.", "Gestor")
                Return True

            Case LigTipo.MSSQL

                Dim NewLig As New SQLMotor(NomeLigacao)
                Ligacoes.Add(LCase(NomeLigacao), NewLig)
                L.RegistaLog("Nova ligação SQL200X adicionada.", "Gestor")
                Return True

            Case LigTipo.MSSQLC
                Dim NewLig As New SQLCMotor(NomeLigacao)
                Ligacoes.Add(LCase(NomeLigacao), NewLig)
                L.RegistaLog("Nova ligação SQL Compact adicionada.", "Gestor")
                Return True

        End Select

    End Function

    ''' <summary>
    ''' Remove uma ligação do gestor de ligações
    ''' </summary>
    ''' <param name="NomeLigacao">Nome de identificação da ligação</param>
    ''' <returns>Boolean. True se sucesso, False se surgir um erro</returns>
    ''' <remarks></remarks>
    Public Function RemoverLigacao(ByVal NomeLigacao As String) As Boolean

        If LigacaoExiste(LCase(NomeLigacao)) = False Then
            ER.ReportarErro(ErrorReporting.NV.Gestor, "Ligação inexistente")
            Return False
        End If

        Dim P() As String = Split(Ligacoes(LCase(NomeLigacao)).ToString, ".")
        Dim Tipo As String = LCase(P(UBound(P)))

        Select Case Tipo

            Case "accessmotor"
                Dim TempT As ACCESSMotor = CType(Ligacoes(LCase(NomeLigacao)), ACCESSMotor)
                Ligacoes.Remove(LCase(NomeLigacao))

            Case "sqlmotor"
                Dim TempT As SQLMotor = CType(Ligacoes(LCase(NomeLigacao)), SQLMotor)
                Ligacoes.Remove(LCase(NomeLigacao))

            Case "sqlcmotor"
                Dim TempT As SQLCMotor = CType(Ligacoes(LCase(NomeLigacao)), SQLCMotor)
                Ligacoes.Remove(LCase(NomeLigacao))

        End Select

        L.RegistaLog("Ligação " & NomeLigacao & " removida", "Gestor")
        Return True

    End Function

    ''' <summary>
    ''' Adiciona um parâmetro para utilizar na próxima query
    ''' </summary>
    ''' <param name="NomeLigacao">Nome de identificação da ligação</param>
    ''' <param name="NomeParametro">Nome do parâmetro a adicionar</param>
    ''' <param name="ValorParametro">Valor do parâmetro a adicionar</param>
    ''' <remarks>A execução de uma query, limpa a lista de parâmetros. No nome do parâmetro, utilizar @ seguido do nome</remarks>
    Public Sub AdicionarParametro(ByVal NomeLigacao As String, ByVal NomeParametro As String, ByVal ValorParametro As Object)
        If LigacaoExiste(LCase(NomeLigacao)) = False Then
            ER.ReportarErro(ErrorReporting.NV.Gestor, "Ligação inexistente")
            Exit Sub
        End If

        Dim P() As String = Split(Ligacoes(LCase(NomeLigacao)).ToString, ".")
        Dim Tipo As String = LCase(P(UBound(P)))

        Select Case Tipo

            Case "accessmotor"
                ER.ReportarErro(ErrorReporting.NV.Gestor, "Este motor de BD não suporta parâmetros")
                Exit Sub

            Case "sqlmotor"
                Dim TempT As SQLMotor = CType(Ligacoes(LCase(NomeLigacao)), SQLMotor)
                TempT.AdicionarParametro(NomeParametro, ValorParametro)

            Case "sqlcmotor"
                Dim TempT As SQLCMotor = CType(Ligacoes(LCase(NomeLigacao)), SQLCMotor)
                TempT.AdicionarParametro(NomeParametro, ValorParametro)
        End Select

    End Sub

    ''' <summary>
    ''' Testar uma ligação
    ''' </summary>
    ''' <param name="NomeLigacao">Nome de identificação da ligação</param>
    ''' <returns>Boolean. True se sucesso, False se surgir um erro</returns>
    ''' <remarks></remarks>
    Public Function Testar(ByVal NomeLigacao As String) As Boolean
        If LigacaoExiste(LCase(NomeLigacao)) = False Then
            ER.ReportarErro(ErrorReporting.NV.Gestor, "Ligação inexistente")
            Return False
        End If

        Dim P() As String = Split(Ligacoes(LCase(NomeLigacao)).ToString, ".")
        Dim Tipo As String = LCase(P(UBound(P)))

        Select Case Tipo

            Case "accessmotor"
                Dim TempT As ACCESSMotor = CType(Ligacoes(LCase(NomeLigacao)), ACCESSMotor)
                L.RegistaLog("Teste pedido a " & NomeLigacao, "Gestor")
                Return TempT.Testar

            Case "sqlmotor"
                Dim TempT As SQLMotor = CType(Ligacoes(LCase(NomeLigacao)), SQLMotor)
                L.RegistaLog("Teste pedido a " & NomeLigacao, "Gestor")
                Return TempT.Testar

            Case "sqlcmotor"
                Dim TempT As SQLMotor = CType(Ligacoes(LCase(NomeLigacao)), SQLMotor)
                L.RegistaLog("Teste pedido a " & NomeLigacao, "Gestor")
                Return TempT.Testar

        End Select
    End Function

#Region "Executar"

    ''' <summary>
    ''' Executar uma query
    ''' </summary>
    ''' <param name="NomeLigacao">Nome de identificação da ligação</param>
    ''' <param name="Query">Query a executar</param>
    ''' <param name="TipoQuery">Tipo da query a executar</param>
    ''' <param name="Timeout">Timeout para a execução da query</param>
    ''' <returns>DataTable com o resultado da query</returns>
    ''' <remarks>Devolve uma DataTable vazia se a query produzir um erro ou não produzir resultados</remarks>
    Public Overloads Function Executar(ByVal NomeLigacao As String, ByVal Query As String, ByVal TipoQuery As TipoQuery, Optional ByVal Timeout As Integer = 999) As DataTable
        Dim DT As New DataTable

        If LigacaoExiste(LCase(NomeLigacao)) = False Then
            ER.ReportarErro(ErrorReporting.NV.Gestor, "Ligação inexistente")
            Return New DataTable
        End If

        Dim P() As String = Split(Ligacoes(LCase(NomeLigacao)).ToString, ".")
        Dim Tipo As String = LCase(P(UBound(P)))

        Select Case Tipo

            Case "accessmotor"
                Dim TempT As ACCESSMotor = CType(Ligacoes(LCase(NomeLigacao)), ACCESSMotor)
                L.RegistaLog("Executada query à base de dados: " & Query, "Gestor")
                DT = TempT.Executar(Query)

            Case "sqlmotor"
                Dim TempT As SQLMotor = CType(Ligacoes(LCase(NomeLigacao)), SQLMotor)
                L.RegistaLog("Executada query à base de dados: " & Query, "Gestor")
                DT = TempT.Executar(Query, TipoQuery)

            Case "sqlcmotor"
                Dim TempT As SQLCMotor = CType(Ligacoes(LCase(NomeLigacao)), SQLCMotor)
                L.RegistaLog("Executada query à base de dados: " & Query, "Gestor")
                DT = TempT.Executar(Query)

        End Select

        If IsDBNull(DT) Then
            Return New DataTable()
        Else
            Return DT
        End If
    End Function

    ''' <summary>
    ''' Executar uma query
    ''' </summary>
    ''' <param name="NomeLigacao">Nome de identificação da ligação</param>
    ''' <param name="Query">Query a executar</param>
    ''' <returns>DataTable com o resultado da query</returns>
    ''' <remarks>Devolve uma DataTable vazia se a query produzir um erro ou não produzir resultados</remarks>
    Public Overloads Function Executar(ByVal NomeLigacao As String, ByVal Query As String) As DataTable
        Dim DT As New DataTable

        If LigacaoExiste(LCase(NomeLigacao)) = False Then
            ER.ReportarErro(ErrorReporting.NV.Gestor, "Ligação inexistente")
            Return New DataTable
        End If

        Dim P() As String = Split(Ligacoes(LCase(NomeLigacao)).ToString, ".")
        Dim Tipo As String = LCase(P(UBound(P)))

        Select Case Tipo

            Case "accessmotor"
                Dim TempT As ACCESSMotor = CType(Ligacoes(LCase(NomeLigacao)), ACCESSMotor)
                L.RegistaLog("Executada query à base de dados: " & Query, "Gestor")
                DT = TempT.Executar(Query)

            Case "sqlmotor"
                Dim TempT As SQLMotor = CType(Ligacoes(LCase(NomeLigacao)), SQLMotor)
                L.RegistaLog("Executada query à base de dados: " & Query, "Gestor")
                DT = TempT.Executar(Query)

            Case "sqlcmotor"
                Dim TempT As SQLCMotor = CType(Ligacoes(LCase(NomeLigacao)), SQLCMotor)
                L.RegistaLog("Executada query à base de dados: " & Query, "Gestor")
                DT = TempT.Executar(Query)

        End Select

        If IsDBNull(DT) Then
            Return New DataTable()
        Else
            Return DT
        End If
    End Function
#End Region

#Region "Configurar"

    ''' <summary>
    ''' Configura uma ligação
    ''' </summary>
    ''' <param name="NomeLigacao">Nome de identificação da ligação</param>
    ''' <param name="Username">Dado de configuração</param>
    ''' <param name="Password">Dado de configuração</param>
    ''' <param name="DataSource">Dado de configuração</param>
    ''' <param name="NomeBD">Dado de configuração</param>
    ''' <returns>Boolean. True se sucesso, False se surgir um erro</returns>
    ''' <remarks></remarks>
    Public Overloads Function Configurar(ByVal NomeLigacao As String, ByVal Username As String, ByVal Password As String, ByVal DataSource As String, ByVal NomeBD As String) As Boolean

        If LigacaoExiste(LCase(NomeLigacao)) = False Then
            ER.ReportarErro(ErrorReporting.NV.Gestor, "Ligação inexistente")
            Return False
        End If

        Dim P() As String = Split(Ligacoes(LCase(NomeLigacao)).ToString, ".")
        Dim Tipo As String = LCase(P(UBound(P)))

        Select Case Tipo

            Case "accessmotor"
                Dim TempT As ACCESSMotor = CType(Ligacoes(LCase(NomeLigacao)), ACCESSMotor)
                TempT.Configuracao.DataSource = DataSource
                L.RegistaLog("Ligação " & NomeLigacao & " configurada", "Gestor")
                Return True

            Case "sqlmotor"
                Dim TempT As SQLMotor = CType(Ligacoes(LCase(NomeLigacao)), SQLMotor)
                TempT.Configuracao.Username = Username
                TempT.Configuracao.DataSource = DataSource
                TempT.Configuracao.Password = Password
                TempT.Configuracao.NomeBD = NomeBD
                L.RegistaLog("Ligação " & NomeLigacao & " configurada", "Gestor")
                Return True

            Case "sqlcmotor"
                Dim TempT As SQLCMotor = CType(Ligacoes(LCase(NomeLigacao)), SQLCMotor)
                TempT.Configuracao.DataSource = DataSource
                TempT.Configuracao.Password = Password
                L.RegistaLog("Ligação " & NomeLigacao & " configurada", "Gestor")
                Return True

        End Select
    End Function

    ''' <summary>
    ''' Configura uma ligação
    ''' </summary>
    ''' <param name="NomeLigacao">Nome de identificação da ligação</param>
    ''' <param name="DataSource">Dado de configuração</param>
    ''' <returns>Boolean. True se sucesso, False se surgir um erro</returns>
    ''' <remarks></remarks>
    Public Overloads Function Configurar(ByVal NomeLigacao As String, ByVal DataSource As String) As Boolean

        If LigacaoExiste(LCase(NomeLigacao)) = False Then
            ER.ReportarErro(ErrorReporting.NV.Gestor, "Ligação inexistente")
            Return False
        End If

        Dim P() As String = Split(Ligacoes(LCase(NomeLigacao)).ToString, ".")
        Dim Tipo As String = LCase(P(UBound(P)))

        Select Case Tipo

            Case "accessmotor"
                Dim TempT As ACCESSMotor = CType(Ligacoes(LCase(NomeLigacao)), ACCESSMotor)
                TempT.Configuracao.DataSource = DataSource
                L.RegistaLog("Ligação " & NomeLigacao & " configurada", "Gestor")
                Return True

            Case "sqlmotor"
                Dim TempT As SQLMotor = CType(Ligacoes(LCase(NomeLigacao)), SQLMotor)
                TempT.Configuracao.DataSource = DataSource
                L.RegistaLog("Ligação " & NomeLigacao & " configurada", "Gestor")
                Return True

            Case "sqlcmotor"
                Dim TempT As SQLCMotor = CType(Ligacoes(LCase(NomeLigacao)), SQLCMotor)
                TempT.Configuracao.DataSource = DataSource
                L.RegistaLog("Ligação " & NomeLigacao & " configurada", "Gestor")
                Return True

        End Select
    End Function

    ''' <summary>
    ''' Configura uma ligação
    ''' </summary>
    ''' <param name="NomeLigacao">Nome de identificação da ligação</param>
    ''' <param name="Password">Dado de configuração</param>
    ''' <param name="DataSource">Dado de configuração</param>
    ''' <returns>Boolean. True se sucesso, False se surgir um erro</returns>
    ''' <remarks></remarks>
    Public Overloads Function Configurar(ByVal NomeLigacao As String, ByVal DataSource As String, ByVal Password As String) As Boolean

        If LigacaoExiste(LCase(NomeLigacao)) = False Then
            ER.ReportarErro(ErrorReporting.NV.Gestor, "Ligação inexistente")
            Return False
        End If

        Dim P() As String = Split(Ligacoes(LCase(NomeLigacao)).ToString, ".")
        Dim Tipo As String = LCase(P(UBound(P)))

        Select Case Tipo

            Case "accessmotor"
                Dim TempT As ACCESSMotor = CType(Ligacoes(LCase(NomeLigacao)), ACCESSMotor)
                TempT.Configuracao.DataSource = DataSource
                L.RegistaLog("Ligação " & NomeLigacao & " configurada", "Gestor")
                Return True

            Case "sqlmotor"
                Dim TempT As SQLMotor = CType(Ligacoes(LCase(NomeLigacao)), SQLMotor)
                TempT.Configuracao.DataSource = DataSource
                TempT.Configuracao.Password = Password
                L.RegistaLog("Ligação " & NomeLigacao & " configurada", "Gestor")
                Return True

            Case "sqlcmotor"
                Dim TempT As SQLCMotor = CType(Ligacoes(LCase(NomeLigacao)), SQLCMotor)
                TempT.Configuracao.DataSource = DataSource
                TempT.Configuracao.Password = Password
                L.RegistaLog("Ligação " & NomeLigacao & " configurada", "Gestor")
                Return True

        End Select
    End Function
#End Region

#End Region

#Region "Métodos internos"
    Private Function LigacaoExiste(ByVal NomeLigacao As String) As Boolean
        If Ligacoes.ContainsKey(LCase(NomeLigacao)) Then
            Return True
        End If
        Return False
    End Function
#End Region

End Class
