﻿Imports System.Data.OleDb

Friend Class ACCESSMotor

#Region "Assinatura"
    'DataGate
    'Por Sérgio Ribeiro
    'ribeirinho55@hotmail.com
#End Region

#Region "Declarações"
    Private omeuNome As String

    Public Structure Conf
        Public DataSource As String
    End Structure

    Public Configuracao As New Conf

#End Region

#Region "Propriedades"

    Public ReadOnly Property Nome() As String
        Get
            Return omeuNome
        End Get
    End Property

    Public ReadOnly Property Tipo() As String
        Get
            Return "ACCESS"
        End Get
    End Property

#End Region

#Region "Inicialização"
    Sub New(ByVal MeuNome As String)
        omeuNome = MeuNome
    End Sub
#End Region

#Region "Métodos expostos"
    Public Function Executar(ByVal Query As String) As DataTable
        Dim ConnString As String = ConstroiConnectionString()
        Dim OleDBCon As New OleDbConnection(ConnString)
        Dim OleCommand As New OleDbCommand(Query, OleDBCon)

        Dim OleAdapter As New OleDbDataAdapter(OleCommand)
        Dim DT As New DataTable
        DT.Locale = System.Globalization.CultureInfo.InvariantCulture

        Try
            OleDBCon.Open()
            OleAdapter.Fill(DT)
            OleDBCon.Close()
            Return DT
        Catch ex As Exception
            ER.ReportarErro(ErrorReporting.NV.DB, ex.Message, Nome)
        End Try

        Return New DataTable
    End Function

    Public Function Testar() As Boolean
        Dim ConnString As String = ConstroiConnectionString()
        Dim OleDBCon As New OleDbConnection(ConnString)

        Try
            OleDBCon.Open()
            OleDBCon.Close()
            Return True
        Catch ex As Exception
            ER.ReportarErro(ErrorReporting.NV.DB, ex.Message, Nome)
            Return False
        End Try
    End Function
#End Region

#Region "Métodos internos"
    Private Function ConstroiConnectionString() As String
        Return "Provider=Microsoft.ACE.OLEDB.12.0;Data Source=" & Configuracao.DataSource & ";Persist Security Info=False;"
    End Function
#End Region

End Class
