﻿Friend Class ErrorReporting

#Region "Assinatura"
    'DataGate
    'Por Sérgio Ribeiro
    'ribeirinho55@hotmail.com
#End Region

#Region "Declarações"
    Public Enum NV
        Gestor
        DB
        Grave
    End Enum

    Public Event ErroGestor(ByVal Mensagem As String)
    Public Event ErroDB(ByVal Mensagem As String, ByVal NomeLigacao As String)
#End Region

#Region "Métodos expostos"
    Public Sub ReportarErro(ByVal Nivel As NV, ByVal Mensagem As String, Optional ByVal NomeLigacao As String = "Não fornecido")
        If EscreverErrosNoLog = True Then L.RegistaLog(Mensagem, NomeLigacao)

        Dim TempErr As String = Mensagem

        If ErroPers <> "" Then
            TempErr = Replace(ErroPers, "%%msg%%", Mensagem)
            TempErr = Replace(TempErr, "%%ligacao%%", NomeLigacao)
        End If

        Select Case Nivel

            Case NV.Gestor
                If LancarEx = True Then
                    Dim E As New Exception(NomeLigacao, New Exception(TempErr))
                    Throw E
                Else
                    RaiseEvent ErroGestor(TempErr)
                End If


            Case NV.DB
                If LancarExDB = True Then
                    Dim E As New Exception(NomeLigacao, New Exception(TempErr))
                    Throw E
                Else
                    RaiseEvent ErroDB(TempErr, NomeLigacao)
                End If


            Case NV.Grave
                Dim E As New Exception(NomeLigacao, New Exception(TempErr))
                Throw E

        End Select
    End Sub
#End Region

End Class
