﻿Friend Class SQLMotor

#Region "Assinatura"
    'DataGate
    'Por Sérgio Ribeiro
    'ribeirinho55@hotmail.com
#End Region

#Region "Declarações"
    Private omeuNome As String
    Public Configuracao As New Conf
    Private Parametros As New Dictionary(Of String, Object)

    Public Enum QT
        Texto
        StoredProcedure
    End Enum

    Public Structure Conf
        Public Username As String
        Public Password As String
        Public DataSource As String
        Public NomeBD As String
    End Structure
#End Region

#Region "Propriedades"
    Public ReadOnly Property Nome() As String
        Get
            Return omeuNome
        End Get
    End Property

    Public ReadOnly Property Tipo() As String
        Get
            Return "SQL200X"
        End Get
    End Property
#End Region

#Region "Inicialização"
    Sub New(ByVal MeuNome As String)
        omeuNome = MeuNome
    End Sub
#End Region

#Region "Métodos expostos"
    Public Function Executar(ByVal Query As String, Optional ByVal Tipo As QT = QT.Texto, Optional ByVal Timeout As Integer = 999) As DataTable
        Dim ConnString = ConstroiConnectionString()
        Dim SQLConn As SqlClient.SqlConnection = New SqlClient.SqlConnection(ConnString)
        Dim SQLCommand As SqlClient.SqlCommand = New SqlClient.SqlCommand(Query, SQLConn)

        Select Case Tipo
            Case QT.StoredProcedure
                SQLCommand.CommandType = Data.CommandType.StoredProcedure

            Case QT.Texto
                SQLCommand.CommandType = Data.CommandType.Text
        End Select

        SQLCommand.CommandTimeout = Timeout

        For Each KVP As KeyValuePair(Of String, Object) In Parametros
            SQLCommand.Parameters.Add(New SqlClient.SqlParameter(KVP.Key, KVP.Value))
        Next

        Try
            SQLConn.Open()
            Dim DA As SqlClient.SqlDataAdapter = New SqlClient.SqlDataAdapter(SQLCommand)
            Dim DT As New DataTable
            DT.Locale = System.Globalization.CultureInfo.InvariantCulture
            DA.Fill(DT)
            SQLConn.Close()
            Parametros.Clear()
            Return DT

        Catch ex As Exception
            If SQLConn.State <> ConnectionState.Closed Then SQLConn.Close()
            ER.ReportarErro(ErrorReporting.NV.DB, ex.Message, Nome)
            Parametros.Clear()
        End Try

        Return New DataTable
    End Function

    Public Function Testar() As Boolean
        Dim ConnString = ConstroiConnectionString()
        Dim SQLConn As SqlClient.SqlConnection = New SqlClient.SqlConnection(ConnString)

        Try
            SQLConn.Open()
            SQLConn.Close()
            Return True
        Catch ex As Exception
            ER.ReportarErro(ErrorReporting.NV.DB, ex.Message, Nome)
            Return False
        End Try
    End Function

    Public Sub AdicionarParametro(ByVal NomeParametro As String, ByVal ValorParametro As String)
        If Parametros.ContainsKey(NomeParametro) Then
            ER.ReportarErro(ErrorReporting.NV.Gestor, "Parâmetro existente", Nome)
            Exit Sub
        End If

        Parametros.Add(NomeParametro, ValorParametro)
        L.RegistaLog("Parâmetro adicionado a " & Nome, "Gestor")
    End Sub
#End Region

#Region "Métodos internos"
    Private Function ConstroiConnectionString() As String
        Return "Data Source=" & Configuracao.DataSource & _
        ";Initial Catalog=" & Configuracao.NomeBD & _
        ";Persist Security Info=True;User ID=" & Configuracao.Username & _
        ";Password=" & Configuracao.Password
    End Function
#End Region

End Class
