﻿Imports System.Data.SqlServerCe

Friend Class SQLCMotor

#Region "Assinatura"
    'DataGate
    'Por Sérgio Ribeiro
    'ribeirinho55@hotmail.com
#End Region

#Region "Declarações"
    Private omeuNome As String

    Public Enum QT
        Texto
        StoredProcedure
    End Enum

    Public Structure Conf
        Public Password As String
        Public DataSource As String
    End Structure

    Public Configuracao As New Conf
    Private Parametros As New Dictionary(Of String, Object)
#End Region

#Region "Propriedades"
    Public ReadOnly Property Nome() As String
        Get
            Return omeuNome
        End Get
    End Property

    Public ReadOnly Property Tipo() As String
        Get
            Return "SQLCOMPACT"
        End Get
    End Property
#End Region

#Region "Inicialização"
    Sub New(ByVal MeuNome As String)
        omeuNome = MeuNome
    End Sub
#End Region

#Region "Métodos expostos"
    Public Function Executar(ByVal Query As String) As DataTable
        Dim ConnString = ConstroiConnectionString()
        Dim SQLConn As SqlCeConnection = New SqlCeConnection(ConnString)
        Dim SQLCommand As SqlCeCommand = New SqlCeCommand(Query, SQLConn)

        For Each KVP As KeyValuePair(Of String, Object) In Parametros
            SQLCommand.Parameters.Add(New SqlClient.SqlParameter(KVP.Key, KVP.Value))
        Next

        Try
            SQLConn.Open()
            Dim DA As SqlCeDataAdapter = New SqlCeDataAdapter(SQLCommand)
            Dim DT As New DataTable
            DT.Locale = System.Globalization.CultureInfo.InvariantCulture
            DA.Fill(DT)
            SQLConn.Close()
            Parametros.Clear()
            Return DT

        Catch ex As Exception
            If SQLConn.State <> ConnectionState.Closed Then SQLConn.Close()
            ER.ReportarErro(ErrorReporting.NV.DB, ex.Message, Nome)
            Parametros.Clear()
        End Try

        Return New DataTable
    End Function

    Public Function Testar() As Boolean
        Dim ConnString = ConstroiConnectionString()
        Dim SQLConn As SqlCeConnection = New SqlCeConnection(ConnString)

        Try
            SQLConn.Open()
            SQLConn.Close()
            Return True
        Catch ex As Exception
            ER.ReportarErro(ErrorReporting.NV.DB, ex.Message, Nome)
            Return False
        End Try
    End Function

    Public Sub AdicionarParametro(ByVal NomeParametro As String, ByVal ValorParametro As String)
        If Parametros.ContainsKey(NomeParametro) Then
            ER.ReportarErro(ErrorReporting.NV.Gestor, "Parâmetro existente", Nome)
            Exit Sub
        End If

        Parametros.Add(NomeParametro, ValorParametro)
        L.RegistaLog("Parâmetro adicionado a " & Nome, "Gestor")
    End Sub
#End Region

#Region "Métodos internos"
    Private Function ConstroiConnectionString() As String
        If Configuracao.Password <> "" Then
            Return "Data Source=" & Configuracao.DataSource & ";Encrypt Database=True;Password=" & Configuracao.Password & ";File Mode=shared read;Persist Security Info=False;"
        Else
            Return "Data Source=" & Configuracao.DataSource
        End If
    End Function
#End Region

End Class
