﻿Imports DataGate.GestorLigacoes.LigTipo

Public Class Form1
    Private WithEvents Dados As New DataGate.GestorLigacoes

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'Adicionar 3 ligações ao gestor de ligações, uma de cada tipo
        Dados.AdicionarLigacao(MSACCESS, "Access")
        Dados.AdicionarLigacao(MSSQL, "SQL200X")
        Dados.AdicionarLigacao(MSSQLC, "SQLCompact")

        'Configura a instância
        Dados.ErrosParaLog = True
        Dados.ManterLog = True
        Dados.ErroPersonalizado = "Ocorreu um erro:" & vbCrLf & vbCrLf & _
        "%%msg%%" & vbCrLf & vbCrLf & "O erro foi disparado a partir da ligação: %%ligacao%%"

        'Demonstando as duas formas de apanhar erros:
        'Erros do gestor são apanhados por evento
        Dados.LancarExcepcoesDoGestor = False
        'Erros da DB são apanhados por InnerException da exception
        Dados.LancarExcepcoesAosErrosDaDB = True

        ActualizaLog()
    End Sub

    Private Sub SQLConfigura_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SQLConfigura.Click
        'Configura a ligação
        'Aqui demonstrando uma utilidade para o facto do método Configurar devolver um boolean de acordo com o seu sucesso
        If Dados.Configurar("SQL200X", SQLUN.Text, SQLPWD.Text, SQLDS.Text, SQLIC.Text) = False Then
            MsgBox("Ligação inexistente")
        End If
        ActualizaLog()
    End Sub

    Private Sub SQLExec_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SQLExec.Click
        'Executa a query
        Try
            SQLDGV.DataSource = Dados.Executar("SQL200X", SQLQuery.Text, DataGate.GestorLigacoes.TipoQuery.Texto, 15)
        Catch ex As Exception
            MsgBox(ex.InnerException.Message)
        End Try
        ActualizaLog()
    End Sub

    Private Sub AccessExec_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AccessExec.Click
        'Executa a query
        Try
            AccessDGV.DataSource = Dados.Executar("Access", ACCEESSQuery.Text)
        Catch ex As Exception
            MsgBox(ex.InnerException.Message)
        End Try

        ActualizaLog()
    End Sub

    Private Sub SQLCExec_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SQLCExec.Click
        'Executa a query
        Try
            SQLCEDGV.DataSource = Dados.Executar("SQLCompact", SQLCEQuery.Text)
        Catch ex As Exception
            MsgBox(ex.InnerException.Message)
        End Try
        ActualizaLog()
    End Sub

    Private Sub AccessConfigura_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AccessConfigura.Click
        'Configura a ligação
        Dados.Configurar("Access", ACCESSDS.Text)
        ActualizaLog()
    End Sub

    Private Sub SQLCEConfigura_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SQLCEConfigura.Click
        'Configura a ligação
        Dados.Configurar("SQLCompact", SQLCDS.Text, SQLCPWD.Text)
        ActualizaLog()
    End Sub

    Private Sub SQLCDS_MouseDoubleClick(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles SQLCDS.MouseDoubleClick
        Dim OFD As New OpenFileDialog
        OFD.ShowDialog()
        If OFD.FileName = Nothing Then Exit Sub
        SQLCDS.Text = OFD.FileName
    End Sub

    Private Sub ACCESSDS_MouseDoubleClick(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles ACCESSDS.MouseDoubleClick
        Dim OFD As New OpenFileDialog
        OFD.ShowDialog()
        If OFD.FileName = Nothing Then Exit Sub
        ACCESSDS.Text = OFD.FileName
    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        PainelSQL.Visible = True
        PainelSQLCE.Visible = False
        PainelAccess.Visible = False
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        PainelSQL.Visible = False
        PainelSQLCE.Visible = False
        PainelAccess.Visible = True
    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
        PainelSQL.Visible = False
        PainelSQLCE.Visible = True
        PainelAccess.Visible = False
    End Sub

    Private Sub Dados_ErroDB(ByVal Mensagem As String, ByVal NomeLigacao As String) Handles Dados.ErroDB
        MsgBox(Mensagem)
    End Sub

    Private Sub Dados_ErroGestor(ByVal Mensagem As String) Handles Dados.ErroGestor
        MsgBox(Mensagem)
    End Sub

    Private Sub ActualizaLog()
        Dim LogList As New List(Of String)
        LogList = Dados.DevolverUltimasEntradasDoLog()

        LOG.Items.Clear()

        For Each L As String In LogList
            LOG.Items.Add(L)
        Next
    End Sub
End Class